(* pomocne funkcije *)
fun duzina(lista) = if(null(lista)) then 0
	else 1 + duzina(tl(lista));

fun qsort [] = []
  | qsort (x::xs) =
    let 
        val (left, right) = List.partition (fn y => y<x) xs
    in
        qsort left @ [x] @ qsort right
    end

(* prvi zadatak *)

fun brPonavljanja(x, lista) = if(null(lista)) then 0
	else if(x = hd(lista)) then 1 + brPonavljanja(x, tl(lista))
	else 0;

fun paroviPonavljanja1(lista, pret) = if(null(lista)) then []
	else if(hd(lista) = pret) then paroviPonavljanja1(tl(lista), hd(lista))
	else (hd(lista), brPonavljanja(hd(lista), lista)) :: paroviPonavljanja1(tl(lista), hd(lista));

fun paroviPonavljanja(lista) = paroviPonavljanja1(lista, ~1094);

(* drugi zadatak *)
fun sortirana1(lista, pret) = if(null(lista)) then true
	else if(pret > hd(lista)) then false
	else sortirana1(tl(lista), hd(lista));

fun sortirana(lista) = if(null(lista)) then true
	else sortirana1(tl(lista), hd(lista));


(* treci zadatak *)
fun provjera(lista1, lista2) = if(null(lista1)) then true
	else if(null(lista2)) then false
	else if(hd(lista1) = hd(lista2)) then provjera(tl(lista1), tl(lista2))
	else false;

fun permutacija(lista1, lista2) = provjera(qsort(lista1), qsort(lista2));


(* cetvrti zadatak *)
fun izdvoji1(a, b, lista, i) = if(null(lista)) then []
	else if((i >= a) andalso (i < b)) then hd(lista)::izdvoji1(a, b, tl(lista), i+1)
	else if(i = b) then [hd(lista)]
	else izdvoji1(a, b, tl(lista), i+1);

fun izdvoji(a, b, lista) = izdvoji1(a, b, lista, 1);

(* peti zadatak *)
fun izbrisi(x, lista) = if(null(lista)) then []
	else if(hd(lista) = x) then izbrisi(x, tl(lista))
	else hd(lista)::izbrisi(x, tl(lista));

(* sesti zadatak *)
fun ponovi1(n, lista, i) = if(null(lista)) then []
	else if(i < n) then hd(lista)::ponovi1(n, lista, i+1)
	else ponovi1(n, tl(lista), 0);

fun ponovi(n, lista) = ponovi1(n, lista, 0);
